library(memisc)
library(magrittr)
rm(list=ls())

load("ESS-relig-choice.RData")
load("CHES_ESS.RData")
load("CHESwork.RData")

is_valid <- function(...){
    args <- list(...)
    res <- TRUE
    for(i in seq_along(args))
        res <- res & is.valid(args[[i]])
    res
}

foreach(ESS_choice_data=c(
            ESS_denom_choice,
            ESS_denom_age_choice,
            ESS_relatt_choice,
            ESS_relatt_age_choice,
            ESS_relatt_denom_choice,
            ESS_pray_choice,
            ESS_pray_age_choice,
            ESS_pray_denom_choice,
            ESS_religious_choice,
            ESS_religious_age_choice,
            ESS_religious_denom_choice),
    ESS_CHES_data=c(
            ESS_denom_CHES,
            ESS_denom_age_CHES,
            ESS_relatt_CHES,
            ESS_relatt_age_CHES,
            ESS_relatt_denom_CHES,
            ESS_pray_CHES,
            ESS_pray_age_CHES,
            ESS_pray_denom_CHES,
            ESS_religious_CHES,
            ESS_religious_age_CHES,
            ESS_religious_denom_CHES),{
                cat("====================================\n")
                ESS_CHES_data <- merge(ESS_choice_data,
                                   CHES_ESS,
                                   by.x=c("CHES_id","year"),
                                   by.y=c("party_id","year"),
                                   all.x=TRUE,all.y=FALSE)               
                ESS_CHES_data <- merge(ESS_CHES_data,
                                       CHESwork,
                                       by.x=c("CHES_id","CHESyear"),
                                       by.y=c("party_id","CHESyear"),
                                       all.x=TRUE,all.y=FALSE)
                # ESS_CHES_data %<>% subset(is_valid(
                #                    lrecon,
                #                    galtan,
                #                    spendvtax,
                #                    deregulation,
                #                    redistribution,
                #                    civlib_laworder,
                #                    sociallifestyle,
                #                    religious_principles,
                #                    immigrate_policy,
                #                    multiculturalism
                #                    ))
                print(dim(ESS_CHES_data))
                print(range(ESS_CHES_data$year))
            })

save(ESS_denom_CHES,
     ESS_denom_age_CHES,
     ESS_relatt_CHES,
     ESS_relatt_age_CHES,
     ESS_relatt_denom_CHES,
     ESS_pray_CHES,
     ESS_pray_age_CHES,
     ESS_pray_denom_CHES,
     ESS_religious_CHES,
     ESS_religious_age_CHES,
     ESS_religious_denom_CHES,
     file="ESS-relig-CHES.RData")

# saveRDS(ESS_denom_CHES, file="ESS_denom_CHES.RDS")
# saveRDS(ESS_denom_age_CHES, file="ESS_denom_age_CHES.RDS")
# saveRDS(ESS_relatt_CHES, file="ESS_relatt_CHES.RDS")
# saveRDS(ESS_relatt_age_CHES, file="ESS_relatt_age_CHES.RDS")
# saveRDS(ESS_relatt_denom_CHES, file="ESS_relatt_denom_CHES.RDS")
# saveRDS(ESS_pray_CHES, file="ESS_pray_CHES.RDS")
# saveRDS(ESS_pray_age_CHES, file="ESS_pray_age_CHES.RDS")
# saveRDS(ESS_pray_denom_CHES, file="ESS_pray_denom_CHES.RDS")
# saveRDS(ESS_religious_CHES, file="ESS_religious_CHES.RDS")
# saveRDS(ESS_religious_age_CHES, file="ESS_religious_age_CHES.RDS")
# saveRDS(ESS_religious_denom_CHES, file="ESS_religious_denom_CHES.RDS")
